PRO CMRC_PROCESS,drgc,res,ngpts,nz,rm,h,lat,cp,c,usf,vsf,us,vs,u,vv,ueth,veth,xkm,ykm

;...
b = h;    % Holland (1980) b parameter
rho = 1.15;  % air density
pe = 1.013e5;   % Environment pressure
ddp=pe-cp & dp=ddp & f = 2*7.292e-5*sin(lat*!pi/180);  % Coriolis parameter
Ut=c

;...
ds = res;   % Grid spacing
lp = ngpts;    % Grid size is 2*lp + 1 square
x=fltarr(2*lp+1,2*lp+1) & y=fltarr(2*lp+1,2*lp+1)
for i=0,2*lp do for j=0,2*lp do x(j,i)=-lp*ds+j*ds
for i=0,2*lp do for j=0,2*lp do y(i,j)=-lp*ds+j*ds

;Here take the transpose of x and y to make it the same 
lam = atan(y,x);
r = sqrt(x^2 + y^2) & zz=where(r eq 0) &  r(zz) = !VALUES.F_NAN ;
xkm = x*1e-3 & ykm = y*1e-3 & xx = xkm(1,*) & yy = ykm(*,1);
cx=fltarr(629) & cy=fltarr(629)
for i=0,628 do cx(i) = rm*1e-3*sin(0+i*0.01);  % Circle for rmw plots.
for i=0,628 do cy(i) = rm*1e-3*cos(0+i*0.01);

;...
@CMRC_GRD.m
;

Vx = -V*y/r;  % Cartesian winds
Vy =  V*x/r;
I2 = (f + 2*V/r)*(f + Z);  % Inertial stability squared

;...
K = 50;    % Diffusivity
C = drgc; % Drag coefficient

;...
; Calculate alpha, beta, gamma, chi, eta and psi in Kepert (2001). 
; The III's are to get the solution in the case where V/r > I.
al = (2 * V / r + f) / (2*K);
be = (f + Z) / (2*K);
gam = V / (2*K*r);
III = where(gam gt sqrt(al*be));
fixup = where ((al eq !VALUES.F_NAN) or (be eq !VALUES.F_NAN) or (gam eq !VALUES.F_NAN));

;...
chi = (C/K)*V / sqrt(sqrt(al*be)      ) & if (fixup ge 0.) then chi( fixup ) = !VALUES.F_NAN;
eta = (C/K)*V / sqrt(sqrt(al*be) + gam) ;
psi = (C/K)*V / sqrt( abs( sqrt(al*be) - gam) )  ;
albe = sqrt(al/be);

; Calculate A_k's ... p and m refer to k = +1 and -1. i is sqrt(-1).
A0 =  -chi*V*(1 + complex(0,1)*(1 + chi)) / ( 2*chi^2 + 3*chi + 2 ) ;
u0s = albe * float(A0);   % Symmetric surface wind component
v0s =         imaginary(A0);
Am = -( (1 + (1+complex(0,1))*eta)/albe $
      + (2 + (1+complex(0,1))*eta) )*psi*Ut $
   / ( (2 + 2*complex(0,1))*(1 + eta*psi) + 3*psi + 3*complex(0,1)*eta ); 
AmIII = -( (1 + (1+complex(0,1))*eta)/albe $
           + (2 + (1+complex(0,1))*eta) )*psi*Ut $
       / ( 2 - 2*complex(0,1) + 3*(psi + eta) + (2 + 2*complex(0,1))*eta*psi );
ums = albe * float( Am * exp(-complex(0,1)*lam) );  % First asymmetric surface component
vms =         imaginary( Am * exp(-complex(0,1)*lam) );
Ap = -( (1 + (1+complex(0,1))*psi)/albe $
      - (2 + (1+complex(0,1))*psi) )*eta*Ut $
   / ( (2 + 2*complex(0,1))*(1 + eta*psi) + 3*eta + 3*complex(0,1)*psi ); 
ApIII = -(  (1 + (1-complex(0,1))*psi)/albe $
           - (2 + (1-complex(0,1))*psi) )*eta*Ut $
       / ( 2 + 2*complex(0,1) + 3*(eta + psi) + (2 - 2*complex(0,1))*eta*psi );
ups = albe * float( Ap * exp(complex(0,1)*lam) ); % Second asymmetric surface component
vps =         imaginary( Ap * exp(complex(0,1)*lam) );


; Total surface wind in (moving coordinate system)...
us =     u0s + ups + ums;
us(lp,lp)=0.0
vs = V + v0s + vps + vms;
vs(lp,lp)=0.0

; Total surface wind in stationary coordinate system (f for fixed)
usf = us + Ut*cos(lam);
vsf = vs - Ut*sin(lam);
Uf =   + Ut*cos(lam);
Vf = V - Ut*sin(lam);
 
;3d part ...
; Coefficients p_k for k = 0, 1, -1.
p0 = -1*(1 + complex(0,1)) * (al * be)^(1/4);
pp = -1*(1 + complex(0,1)) * sqrt( sqrt(al * be) + gam );
pm = -1*(1 + complex(0,1)) * sqrt( abs( sqrt(al * be) - gam ) );
;if (III ge 0.0) then pm(III) = -complex(0,1) * pm(III);

; Set up a 3-d grid and calculate winds and horizontal divergence,
z=intarr(nz) 
for i=0,nz-1 do z(i) = i*10;

;
nx=2*lp+1 & ny=2*lp+1
u=replicate(0.0,nz,ny,nx) & vv=replicate(0.0,nz,ny,nx) ;
ux=replicate(0.0,nz,ny,nx) & vx=replicate(0.0,nz,ny,nx);
hdiv=replicate(0.0,nz,ny,nx) & hdiva=replicate(0.0,nz,ny,nx);
uxa=replicate(0.0,nz,ny,nx) & vxa=replicate(0.0,nz,ny,nx);
w=replicate(0.0,nz,ny,nx) & wa=replicate(0.0,nz,ny,nx);

;
ua=fltarr(nz,ny,nx) & va=fltarr(nz,ny,nx)
ueth=fltarr(nz,ny,nx) & veth=fltarr(nz,ny,nx)

for kk = 0,nz-1 do begin  &$
   wm = Am * exp(z(kk)*pm - complex(0,1)*lam) &$; wm(fixup) = !VALUES.F_NAN &$
   w0 = A0 * exp(z(kk)*p0)  &$;  w0(fixup) = !VALUES.F_NAN &$
   wp = Ap * exp(z(kk)*pp + complex(0,1)*lam) &$; wp(fixup) = !VALUES.F_NAN &$
   u(kk,*,*) =     albe*float(wm + w0 + wp) &$
   vv(kk,*,*) = V+imaginary(wm + w0 + wp) &$
   ua(kk,*,*) = albe*float(wm + wp) &$
   va(kk,*,*) =       imaginary(wm + wp) &$
   ux(kk,*,*) = ( reform(u(kk,*,*))*x - reform(vv(kk,*,*))*y ) / r  &$
   vx(kk,*,*) = ( reform(vv(kk,*,*))*x + reform(u(kk,*,*))*y ) / r  &$
   uxa(kk,*,*) = ( reform(ua(kk,*,*))*x - reform(va(kk,*,*))*y ) / r  &$
   vxa(kk,*,*) = ( reform(va(kk,*,*))*x + reform(ua(kk,*,*))*y ) / r  &$
endfor

;EARTH RELATIVE WIND
for kk=0,nz-1 do begin &$
  ueth(kk,*,*)=u(kk,*,*)+ Ut*cos(lam) &$
  veth(kk,*,*)=vv(kk,*,*)-Ut*sin(lam) &$
endfor
ueth(*,lp,lp)=0.0
veth(*,lp,lp)=0.0

;....
END; CMRC_PROCESS
