PRO CMRC_LLTOXY,glon,glat,xmerc,ymerc,elo,gglo
compile_opt hidden
on_error,1
if n_params() eq 0 then begin 
print,'CMRC_LLTOXY,glon,glat,xmerc,ymerc,elo,gglo'
return&endif

;initialization
rdsequ=6378.4e3 & rdspol=6356.9e3 & rdssph=6378.e3
cgclgg=(rdspol/rdsequ)^2 & crdndg=3.1415926536/180 
gclo=atan(cgclgg*tan(crdndg*gglo)) & fmlo=1/cos(gclo)
cygcl=rdssph/fmlo & cxelo=cygcl*crdndg & crdss2=2*cygcl
xmo=cxelo*elo & yno=cygcl*alog((1+tan(gclo/2))/(1-tan(gclo/2)))
;
;... mercator x coordinates from longitudes
xmerc=cxelo*glon-xmo 
;
;... mercator y coordinates from latitudes
gcl=atan(cgclgg*tan(crdndg*glat)) & z=tan(0.5*gcl)
ymerc=cygcl*alog((1.+z)/(1.-z))-yno
END ;CMRC_LLTOXY.PRO
