;...
bnow=fltarr(nz,pixr,pixa) & cnow=fltarr(nz,pixr,pixa)
zbczip=complexarr(nz,nzip,kmax/kinc+1) 
bc_werzipx=fltarr(nz,nzip) & bc_zuvzipx=complexarr(nz,nzip) & bc_szip=bc_werzipx

;...calculate all time series
jj=-1 & for k=0,kmax-1,kinc do begin jj=jj+1
elc=elonk(k) & nlc=nlatk(k) & rmw=rmwk(k)

;...determine which zipcodes will be affected by current storm position
for i=0,nzip-1 do $
szip(i)=MAP_2POINTS(elc,nlc,elzip(i),nlzip(i),/meters)/(1e3*rmw)
reachx=REACH(rmw) & reachx=reachx(0) & reachx=min([reachx,12.5])
izip=where(szip le reachx,ict)
if ict eq 0  then goto,labela

;...generate relevent portion of gridded field for current time (k)
for i=0,pixr-1 do for j=0,pixa-1 do begin
kz=k
unow(i,j)=spl_interp(ktime,usnap(i,j,*),d2usnap(i,j,*),kz)
vnow(i,j)=spl_interp(ktime,vsnap(i,j,*),d2vsnap(i,j,*),kz)
endfor

;...find the upper/lower bound for k or kz
first=0 & last=0 & nelt=size(ktime,/n_elements) & kz=k
for j=0,nelt-2 do if (kz ge ktime(j)) then first=j
for j=0,nelt-2 do if ((kz ge ktime(j)) and (kz le ktime(j+1))) then last=j+1

;...
;print,'before the interp routine for utest/vtest...',systime()
udum=fltarr(pixr,pixa,2) & vdum=fltarr(pixr,pixa,2)
dudum=fltarr(pixr,pixa,2) & dvdum=fltarr(pixr,pixa,2)
ut=fltarr(nz,pixr,pixa,2) & vt=fltarr(nz,pixr,pixa,2)
dut=fltarr(nz,pixr,pixa,2) & dvt=fltarr(nz,pixr,pixa,2)
for nn=0,nz-1 do begin
for i=0,pixr-1 do for j=0,pixa-1 do begin
kz=k 
ut=utest(nn,i,j,0:1) & vt=vtest(nn,i,j,0:1)
dut=d2utest(nn,i,j,0:1) & dvt=d2vtest(nn,i,j,0:1)
bnow(nn,i,j)=spl_interp(ktime(first:last),utest(nn,i,j,first:last),d2utest(nn,i,j,first:last),kz)
cnow(nn,i,j)=spl_interp(ktime(first:last),vtest(nn,i,j,first:last),d2vtest(nn,i,j,first:last),kz)
endfor
endfor

;...evaluate marine windfield components at admissible zipcode centroids
elz=elzip(izip) & nlz=nlzip(izip)
CMRC_LLTOXY,elz,nlz,xmerc,ymerc,elc,nlc
sdx=sqrt(xmerc^2+ymerc^2)/(100*rmw)
odx=18*(atan(ymerc,xmerc)/!pi+1)
zuvnow=complex(unow(0:pixr-1,1:pixa-2),vnow(0:pixr-1,1:pixa-2))
zerzip=interpolate(zuvnow,sdx,odx,cubic=-.5)

;...
zbcnow=complex(bnow(0:nz-1,0:pixr-1,1:pixa-2),cnow(0:nz-1,0:pixr-1,1:pixa-2))
bc_zerzip=interpolate(zbcnow,sdx,odx,cubic=-.5)

;...archive the "open terrain" wind components in array format
CMRC_ZMAR2ZOT,zerzip,zotzip
zbczip(*,izip,jj)=bc_zerzip
zuvzip(izip,jj)=zerzip & labela: & endfor
wzip=float(sqrt(zuvzip*conj(zuvzip)))
bc_wzip=float(sqrt(zbczip*conj(zbczip)))

;...
;...record maximum total "ot" windspeed at each zipcode
for i=0,nzip-1 do werzipx(i)=max(wzip(i,*)) & index=where(werzipx ne 0.,ict) & sflg=0 
for j=0,ict-1 do begin  jct=where(wzip(index(j),*) eq werzipx(index(j)))
zuvzipx(index(j))=zuvzip(index(j),jct) &endfor

;...obtain marine and "open terrain" peak winds at landfall or lowest pressure fix
ilf=where(lsflg eq 1,jct) & if jct eq 0 then ilf=where(lsflg eq 4)

for jj=1,n_elements(ilf) do begin
zsnaplf=zsnap(*,*,ilf(jj-1))
wsnaplf=float(sqrt(zsnaplf*conj(zsnaplf)))

;...marine winds to open terrain winds
CMRC_ZMAR2ZOT,zsnaplf,zotlf

;...peak winds at landfall or lowest pressure fix
wotlf=float(sqrt(zotlf*conj(zotlf)))
wslfx=max(wsnaplf) & iwslfx=where(wsnaplf eq wslfx)
wotlfx=max(wotlf)  & iwotlfx=where(wotlf eq wotlfx)
zsnaplfx=zsnaplf(iwslfx) & zotlfx=zotlf(iwotlfx)

;...time and location of landfall or lowest pressure fix
daylf=day(ilf(jj-1)) & hourlf=zhour(ilf(jj-1)) & minlf=zmin(ilf(jj-1))
elonlf=elon(ilf(jj-1)) & nlatlf=nlat(ilf(jj-1))

;...make file if any zipcodes are affected by this cyclone
if jj eq 1 then begin
flcnt=flcnt+1 & sflg=ict
offset=fix(60*zhour(0)+zmin(0)) &endif

;...write and label current output file
lbl='landfall:' & if jct eq 0 then lbl='bypass:'
if jj eq 1 then openw,lu,'MODEL_OUTPUT'+strcompress(flcnt,/REMOVE_ALL)+'.dat',/get_lun
header='levels        day    hour     min      zonal     meridional    total m/s dir(deg)'
printf,lu,string
printf,lu,lbl+'  longitude:',elonlf,' deg   latitude:',nlatlf,' deg'
printf,lu,header
printf,lu,' SFC    ',fix(daylf),fix(hourlf),fix(minlf),float(zsnaplfx(0)),imaginary(zsnaplfx(0)),wslfx(0),$
fix(180*(atan(float(zsnaplfx(0)),imaginary(zsnaplfx(0)))/!pi+1.))
;print,'***in the for loop****'
endfor
for i=0,sflg-1 do begin ixi=where(wzip(index(i),*) ne 0.) 
jxj=where(wzip(index(i),ixi) eq werzipx(index(i)))  
printf,lu,' '
printf,lu,'zipcode:',zip(index(i)),'  longitude:',elzip(index(i)),$
' deg   latitude:',nlzip(index(i)),' deg'

DAyz=1+(offset+kinc*ixi(jxj(0)))/1440. & hourz=24*(dayz-fix(dayz))
minz=60*(hourz-fix(hourz)) & jxm=where(fix(round(minz)) eq 60,jct)
if jct ne 0 then begin minz(jxm)=0. & hourz(jxm)=1.+hourz(jxm) &endif
printf,lu,header
nn=1 &  printf,lu,'SFC     ',fix(dayz),fix(hourz),fix(round(minz)),$  
float(zbczip(nn,index(i),ixi(jxj(0)))),imaginary(zbczip(nn,index(i),ixi(jxj(0)))),$
bc_wzip(nn,index(i),ixi(jxj(0))),fix(180*(atan(float(zbczip(nn,index(i),ixi(jxj(0)))),$
imaginary(zbczip(nn,index(i),ixi(jxj(0)))))/!pi+1.)) 
for nn=2,10 do printf,lu,'SFC+ '+strcompress(nn*10-10)+'m',fix(dayz),fix(hourz),fix(round(minz)),$  
float(zbczip(nn,index(i),ixi(jxj(0)))),imaginary(zbczip(nn,index(i),ixi(jxj(0)))),$
bc_wzip(nn,index(i),ixi(jxj(0))),fix(180*(atan(float(zbczip(nn,index(i),ixi(jxj(0)))),$
imaginary(zbczip(nn,index(i),ixi(jxj(0)))))/!pi+1.)) 
for nn=11,nz-1 do printf,lu,'SFC+'+strcompress(nn*10-10)+'m',fix(dayz),fix(hourz),fix(round(minz)),$  
float(zbczip(nn,index(i),ixi(jxj(0)))),imaginary(zbczip(nn,index(i),ixi(jxj(0)))),$
bc_wzip(nn,index(i),ixi(jxj(0))),fix(180*(atan(float(zbczip(nn,index(i),ixi(jxj(0)))),$
imaginary(zbczip(nn,index(i),ixi(jxj(0)))))/!pi+1.)) &endfor
close,lu & free_lun,lu
labelb: & print,'DONE....' 
;
