;...
bnow=fltarr(nz,pixr,pixa) & cnow=fltarr(nz,pixr,pixa)
zbczip=complexarr(nz,nzip,kmax/kinc+1) 
bc_werzipx=fltarr(nz,nzip) & bc_zuvzipx=complexarr(nz,nzip) & bc_szip=bc_werzipx

;...calculate all time series
jj=-1 & for k=0,kmax-1,kinc do begin jj=jj+1
elc=elonk(k) & nlc=nlatk(k) & rmw=rmwk(k)

;...determine which zipcodes will be affected by current storm position
for i=0,nzip-1 do $
szip(i)=MAP_2POINTS(elc,nlc,elzip(i),nlzip(i),/meters)/(1e3*rmw)
reachx=REACH(rmw) & reachx=reachx(0) & reachx=min([reachx,12.5])
izip=where(szip le reachx,ict)
if ict eq 0  then goto,labela

;...generate relavent portion of gridded field for current time (k)
for i=0,pixr-1 do for j=0,pixa-1 do begin
kz=k
unow(i,j)=spl_interp(ktime,usnap(i,j,*),d2usnap(i,j,*),kz)
vnow(i,j)=spl_interp(ktime,vsnap(i,j,*),d2vsnap(i,j,*),kz)
endfor

;...
for nn=0,nz-1 do begin
for i=0,pixr-1 do for j=0,pixa-1 do begin
kz=k
bnow(nn,i,j)=spl_interp(ktime,utest(nn,i,j,*),d2utest(nn,i,j,*),kz)
cnow(nn,i,j)=spl_interp(ktime,vtest(nn,i,j,*),d2vtest(nn,i,j,*),kz)
endfor
endfor

;...evaluate marine windfield components at admissible zipcode centroids
elz=elzip(izip) & nlz=nlzip(izip)
CMRC_LLTOXY,elz,nlz,xmerc,ymerc,elc,nlc
zuvnow=complex(unow(0:pixr-1,1:pixa-2),vnow(0:pixr-1,1:pixa-2))
sdx=xmerc/res +replicate(ngpts,fix(size(xmerc,/dim)))
odx=ymerc/res+replicate(ngpts,fix(size(ymerc,/dim))) 
zerzip=interpolate(zuvnow,sdx,odx,cubic=-.5)

;...at all levels
zbcnow=complex(bnow(0:nz-1,0:pixr-1,1:pixa-2),cnow(0:nz-1,0:pixr-1,1:pixa-2))
bc_zerzip=interpolate(zbcnow,sdx,odx,cubic=-.5)

;...archive the "open terrain" wind components in array format
zbczip(*,izip,jj)=bc_zerzip
zuvzip(izip,jj)=zerzip & labela: & endfor
;...now we have the time series at all zipcodes 
wzip=float(sqrt(zuvzip*conj(zuvzip)))
bc_wzip=float(sqrt(zbczip*conj(zbczip)))

;...record maximum total "ot" windspeed at each zipcode
for i=0,nzip-1 do werzipx(i)=max(wzip(i,*)) & index=where(werzipx ne 0.,ict) & sflg=0 
;...get rid of the zero max wind 
for j=0,ict-1 do begin  jct=where(wzip(index(j),*) eq werzipx(index(j)))
;if (jct ge 0) then zuvzipx(index(j))=zuvzip(index(j),jct) &endfor
zuvzipx(index(j))=zuvzip(index(j),jct) &endfor

;...obtain marine and "open terrain" peak winds at landfall or lowest pressure fix
ilf=where(lsflg eq 1,jct) & if jct eq 0 then ilf=where(lsflg eq 4)

for jj=1,n_elements(ilf) do begin
zsnaplf=zsnap(*,*,ilf(jj-1))
wsnaplf=float(sqrt(zsnaplf*conj(zsnaplf)))

;...marine winds to open terrain winds
CMRC_ZMAR2ZOT,zsnaplf,zotlf

;...peak winds at landfall or lowest pressure fix
wotlf=float(sqrt(zotlf*conj(zotlf)))
wslfx=max(wsnaplf) & iwslfx=where(wsnaplf eq wslfx)
wotlfx=max(wotlf)  & iwotlfx=where(wotlf eq wotlfx)
zsnaplfx=zsnaplf(iwslfx) & zotlfx=zotlf(iwotlfx)

;...time and location of landfall or lowest pressure fix
daylf=day(ilf(jj-1)) & hourlf=zhour(ilf(jj-1)) & minlf=zmin(ilf(jj-1))
elonlf=elon(ilf(jj-1)) & nlatlf=nlat(ilf(jj-1))

;...make file if any zipcodes are affected by this cyclone
;if ict eq 0 then goto,labelb 
if jj eq 1 then begin
flcnt=flcnt+1 & sflg=ict
offset=fix(60*zhour(0)+zmin(0)) &endif
;...write and label current output file
lbl='landfall:' & if jct eq 0 then lbl='bypass:'
if jj eq 1 then openw,lu,'MODEL_OUTPUT'+strcompress(flcnt,/REMOVE_ALL)+'.dat',/get_lun
header='levels        day    hour     min      zonal     meridional    total m/s dir(deg)'
printf,lu,string
printf,lu,lbl+'  longitude:',elonlf,' deg   latitude:',nlatlf,' deg'
printf,lu,header
printf,lu,' SFC    ',fix(daylf),fix(hourlf),fix(minlf),float(zsnaplfx(0)),imaginary(zsnaplfx(0)),wslfx(0),$
fix(180*(atan(float(zsnaplfx(0)),imaginary(zsnaplfx(0)))/!pi+1.))
endfor
for i=0,sflg-1 do begin ixi=where(wzip(index(i),*) ne 0.) 
jxj=where(wzip(index(i),ixi) eq werzipx(index(i)))  
printf,lu,' '
printf,lu,'zipcode:',zip(index(i)),'  longitude:',elzip(index(i)),$
' deg   latitude:',nlzip(index(i)),' deg'

dayz=1+(offset+kinc*ixi(jxj(0)))/1440. & hourz=24*(dayz-fix(dayz))
minz=60*(hourz-fix(hourz)) & jxm=where(fix(round(minz)) eq 60,jct)
if jct ne 0 then begin minz(jxm)=0. & hourz(jxm)=1.+hourz(jxm) &endif
printf,lu,header
nn=0 &  printf,lu,'SFC     ',fix(dayz),fix(hourz),fix(round(minz)),$  
float(zbczip(nn,index(i),ixi(jxj(0)))),imaginary(zbczip(nn,index(i),ixi(jxj(0)))),$
bc_wzip(nn,index(i),ixi(jxj(0))),fix(180*(atan(float(zbczip(nn,index(i),ixi(jxj(0)))),$
imaginary(zbczip(nn,index(i),ixi(jxj(0)))))/!pi+1.))  &endfor
close,lu & free_lun,lu
labelb: & print,'PEAK WINDS LISTING COMPLETED' 
;
